/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.PropertyStateEvent;

public class BindingGroup {
    private final List<Binding> unbound = new ArrayList<Binding>();
    private final List<Binding> bound = new ArrayList<Binding>();
    private List<BindingListener> listeners;
    private Handler handler;
    private Map<String, Binding> namedBindings;

    public final void addBinding(Binding binding) {
        if (binding == null) {
            throw new IllegalArgumentException("Binding must be non-null");
        }
        if (binding.isManaged()) {
            throw new IllegalArgumentException("Managed bindings can't be in a group");
        }
        if (this.bound.contains(binding) || this.unbound.contains(binding)) {
            throw new IllegalArgumentException("Group already contains this binding");
        }
        String name = binding.getName();
        if (name != null) {
            if (this.getBinding(name) != null) {
                throw new IllegalArgumentException("Context already contains a binding with name \"" + name + "\"");
            }
            this.putNamed(name, binding);
        }
        binding.addBindingListener(this.getHandler());
        if (binding.isBound()) {
            this.bound.add(binding);
        } else {
            this.unbound.add(binding);
        }
    }

    public final void removeBinding(Binding binding) {
        if (binding == null) {
            throw new IllegalArgumentException("Binding must be non-null");
        }
        if (binding.isBound() ? !this.bound.remove(binding) : !this.unbound.remove(binding)) {
            throw new IllegalArgumentException("Unknown Binding");
        }
        String name = binding.getName();
        if (name != null) {
            assert (this.namedBindings != null);
            this.namedBindings.remove(name);
        }
        binding.removeBindingListener(this.getHandler());
    }

    private void putNamed(String name, Binding binding) {
        if (this.namedBindings == null) {
            this.namedBindings = new HashMap<String, Binding>();
        }
        this.namedBindings.put(name, binding);
    }

    public final Binding getBinding(String name) {
        if (name == null) {
            throw new IllegalArgumentException("cannot fetch unnamed bindings");
        }
        return this.namedBindings == null ? null : this.namedBindings.get(name);
    }

    public final List<Binding> getBindings() {
        ArrayList<Binding> list = new ArrayList<Binding>(this.bound);
        list.addAll(this.unbound);
        return Collections.unmodifiableList(list);
    }

    public void bind() {
        ArrayList<Binding> toBind = new ArrayList<Binding>(this.unbound);
        for (Binding binding : toBind) {
            binding.bind();
        }
    }

    public void unbind() {
        ArrayList<Binding> toUnbind = new ArrayList<Binding>(this.bound);
        for (Binding binding : toUnbind) {
            binding.unbind();
        }
    }

    public final void addBindingListener(BindingListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<BindingListener>();
        }
        this.listeners.add(listener);
    }

    public final void removeBindingListener(BindingListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public final BindingListener[] getBindingListeners() {
        if (this.listeners == null) {
            return new BindingListener[0];
        }
        BindingListener[] ret = new BindingListener[this.listeners.size()];
        ret = this.listeners.toArray(ret);
        return ret;
    }

    private final Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    private class Handler
    implements BindingListener {
        private Handler() {
        }

        @Override
        public void syncFailed(Binding binding, Binding.SyncFailure failure) {
            if (BindingGroup.this.listeners == null) {
                return;
            }
            for (BindingListener listener : BindingGroup.this.listeners) {
                listener.syncFailed(binding, failure);
            }
        }

        @Override
        public void synced(Binding binding) {
            if (BindingGroup.this.listeners == null) {
                return;
            }
            for (BindingListener listener : BindingGroup.this.listeners) {
                listener.synced(binding);
            }
        }

        @Override
        public void sourceChanged(Binding binding, PropertyStateEvent event) {
            if (BindingGroup.this.listeners == null) {
                return;
            }
            for (BindingListener listener : BindingGroup.this.listeners) {
                listener.sourceChanged(binding, event);
            }
        }

        @Override
        public void targetChanged(Binding binding, PropertyStateEvent event) {
            if (BindingGroup.this.listeners == null) {
                return;
            }
            for (BindingListener listener : BindingGroup.this.listeners) {
                listener.targetChanged(binding, event);
            }
        }

        @Override
        public void bindingBecameBound(Binding binding) {
            BindingGroup.this.unbound.remove(binding);
            BindingGroup.this.bound.add(binding);
            if (BindingGroup.this.listeners == null) {
                return;
            }
            for (BindingListener listener : BindingGroup.this.listeners) {
                listener.bindingBecameBound(binding);
            }
        }

        @Override
        public void bindingBecameUnbound(Binding binding) {
            BindingGroup.this.bound.remove(binding);
            BindingGroup.this.unbound.add(binding);
            if (BindingGroup.this.listeners == null) {
                return;
            }
            for (BindingListener listener : BindingGroup.this.listeners) {
                listener.bindingBecameUnbound(binding);
            }
        }
    }
}

