/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdesktop.beansbinding.ext.BeanAdapterFactory;
import org.jdesktop.el.BeanELResolver;
import org.jdesktop.el.CompositeELResolver;
import org.jdesktop.el.ELContext;
import org.jdesktop.el.ELResolver;
import org.jdesktop.el.FunctionMapper;
import org.jdesktop.el.MapELResolver;
import org.jdesktop.el.VariableMapper;
import org.jdesktop.el.impl.lang.FunctionMapperImpl;
import org.jdesktop.el.impl.lang.VariableMapperImpl;

class TempELContext
extends ELContext {
    private final CompositeELResolver resolver;
    private final VariableMapper variableMapper = new VariableMapperImpl();
    private final FunctionMapper functionMapper = new FunctionMapperImpl();

    public TempELContext() {
        this.resolver = new CompositeELResolver();
        this.resolver.add(new MapELResolver());
        this.resolver.add(new BeanDelegateELResolver());
    }

    @Override
    public ELResolver getELResolver() {
        return this.resolver;
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    @Override
    public VariableMapper getVariableMapper() {
        return this.variableMapper;
    }

    private class BeanDelegateELResolver
    extends BeanELResolver {
        private BeanDelegateELResolver() {
        }

        @Override
        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            List<PropertyDescriptor> pds;
            Iterator<FeatureDescriptor> superDescriptors = super.getFeatureDescriptors(context, base);
            if (base != null && (pds = BeanAdapterFactory.getAdapterPropertyDescriptors(base.getClass())).size() > 0) {
                HashMap<String, FeatureDescriptor> fdMap = new HashMap<String, FeatureDescriptor>();
                while (superDescriptors.hasNext()) {
                    FeatureDescriptor fd = superDescriptors.next();
                    fdMap.put(fd.getName(), fd);
                }
                for (PropertyDescriptor pd : pds) {
                    if (pd.getPropertyType() == null) continue;
                    pd.setValue("type", pd.getPropertyType());
                    pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
                    fdMap.put(pd.getName(), pd);
                }
                return fdMap.values().iterator();
            }
            return superDescriptors;
        }

        private Object baseOrAdapter(Object base, Object property) {
            Object adapter;
            if (base != null && property instanceof String && (adapter = BeanAdapterFactory.getAdapter(base, (String)property)) != null) {
                return adapter;
            }
            return base;
        }

        @Override
        public void setValue(ELContext context, Object base, Object property, Object val) {
            super.setValue(context, this.baseOrAdapter(base, property), property, val);
        }

        @Override
        public boolean isReadOnly(ELContext context, Object base, Object property) {
            return super.isReadOnly(context, this.baseOrAdapter(base, property), property);
        }

        @Override
        public Object getValue(ELContext context, Object base, Object property) {
            return super.getValue(context, this.baseOrAdapter(base, property), property);
        }

        @Override
        public Class<?> getType(ELContext context, Object base, Object property) {
            return super.getType(context, this.baseOrAdapter(base, property), property);
        }
    }
}

